<?php
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$q = trim($_GET['q'] ?? '');

$sql = "
SELECT
    l.id,
    l.reference,
    l.side,
    l.surface,
    l.price,
    l.status,
    p.name  AS project_name,
    lt.name AS lot_type
FROM lots l
LEFT JOIN projects p   ON p.id = l.project_id
LEFT JOIN lot_types lt ON lt.id = l.lot_type_id
";

$params = [];

if ($q !== '') {
    $sql .= " WHERE l.reference LIKE ?";
    $params[] = "%$q%";
}

$sql .= " ORDER BY l.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$lots = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$lots) {
    echo '<tr><td colspan="9" class="text-center text-muted">Aucun lot trouvé</td></tr>';
    exit;
}

foreach ($lots as $l):
?>
<tr>
  <td><?= (int)$l['id'] ?></td>
  <td><?= e($l['project_name']) ?></td>
  <td><?= e($l['reference']) ?></td>
  <td>
    <?= $l['side'] === 'droite' ? 'À droite' : ($l['side'] === 'gauche' ? 'À gauche' : '-') ?>
  </td>
  <td><?= e($l['lot_type']) ?></td>
  <td><?= number_format($l['surface'], 2) ?> m²</td>
  <td><?= number_format($l['price'], 0, ' ', ' ') ?> DA</td>
  <td>
    <span class="badge badge-<?=
      match($l['status']) {
        'disponible' => 'success',
        'reserve'    => 'warning',
        'vendu'      => 'primary',
        'bloque'     => 'danger',
        default      => 'secondary'
      }
    ?>">
      <?= e($l['status']) ?>
    </span>
  </td>
  <td>
    <a href="edit.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-primary">
      <i class="fas fa-edit"></i>
    </a>
  </td>
</tr>
<?php endforeach; ?>
