<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager']);

$title  = "Gestion des lots | IMMOTECH";
$active = 'lots';

/* =====================
   COMPTEURS LOTS
   ===================== */
$stats = $pdo->query("
    SELECT 
        COUNT(*) AS total,
        SUM(status = 'disponible') AS disponible,
        SUM(status = 'reserve')    AS reserve,
        SUM(status = 'vendu')      AS vendu,
        SUM(status = 'bloque')     AS bloque
    FROM lots
")->fetch(PDO::FETCH_ASSOC);


/* =====================
   FILTRES
   ===================== */
$filter_project = (int)($_GET['project_id'] ?? 0);
$filter_type    = (int)($_GET['lot_type_id'] ?? 0);
$filter_status  = $_GET['status'] ?? '';

$where  = [];
$params = [];

/* =====================
   CONSTRUCTION SQL
   ===================== */
if ($filter_project > 0) {
    $where[]  = 'l.project_id = ?';
    $params[] = $filter_project;
}

if ($filter_type > 0) {
    $where[]  = 'l.lot_type_id = ?';
    $params[] = $filter_type;
}

if ($filter_status !== '') {
    $where[]  = 'l.status = ?';
    $params[] = $filter_status;
}

$sql = "
SELECT
    l.id,
    l.reference,
    l.side,
    l.surface,
    l.price,
    l.status,
    p.name  AS project_name,
    lt.name AS lot_type
FROM lots l
LEFT JOIN projects p   ON p.id = l.project_id
LEFT JOIN lot_types lt ON lt.id = l.lot_type_id
";

if ($where) {
    $sql .= ' WHERE ' . implode(' AND ', $where);
}

$sql .= ' ORDER BY l.id DESC';

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$lots = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* =====================
   DONNÉES POUR FILTRES
   ===================== */
$projects = $pdo->query("SELECT id, name FROM projects ORDER BY name")->fetchAll();
$types    = $pdo->query("SELECT id, name FROM lot_types ORDER BY name")->fetchAll();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0"><strong>Gestion des lots</strong></h3>
  <a class="btn btn-success" href="<?= e(base_url('/public/lots/create.php')) ?>">
    <i class="fas fa-plus"></i> Ajouter un lot
  </a>
</div>

<div class="row mb-3">

  <div class="col-md-2">
    <div class="small-box bg-info">
      <div class="inner">
        <h3><?= (int)$stats['total'] ?></h3>
        <p>Total lots</p>
      </div>
      <div class="icon">
        <i class="fas fa-layer-group"></i>
      </div>
    </div>
  </div>

  <div class="col-md-2">
    <div class="small-box bg-success">
      <div class="inner">
        <h3><?= (int)$stats['disponible'] ?></h3>
        <p>Disponibles</p>
      </div>
      <div class="icon">
        <i class="fas fa-check-circle"></i>
      </div>
    </div>
  </div>

  <div class="col-md-2">
    <div class="small-box bg-warning">
      <div class="inner">
        <h3><?= (int)$stats['reserve'] ?></h3>
        <p>Réservés</p>
      </div>
      <div class="icon">
        <i class="fas fa-bookmark"></i>
      </div>
    </div>
  </div>

  <div class="col-md-2">
    <div class="small-box bg-primary">
      <div class="inner">
        <h3><?= (int)$stats['vendu'] ?></h3>
        <p>Vendus</p>
      </div>
      <div class="icon">
        <i class="fas fa-handshake"></i>
      </div>
    </div>
  </div>

  <div class="col-md-2">
    <div class="small-box bg-danger">
      <div class="inner">
        <h3><?= (int)$stats['bloque'] ?></h3>
        <p>Bloqués</p>
      </div>
      <div class="icon">
        <i class="fas fa-ban"></i>
      </div>
    </div>
  </div>

</div>

<!-- FILTRES -->
<div class="card mb-3">
  <div class="card-body">
    <form method="get" class="row g-2">

      <div class="col-md-4">
        <label>Projet</label>
        <select name="project_id" class="form-control">
          <option value="">Tous</option>
          <?php foreach ($projects as $p): ?>
            <option value="<?= $p['id'] ?>" <?= $filter_project === (int)$p['id'] ? 'selected' : '' ?>>
              <?= e($p['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label>Type de lot</label>
        <select name="lot_type_id" class="form-control">
          <option value="">Tous</option>
          <?php foreach ($types as $t): ?>
            <option value="<?= $t['id'] ?>" <?= $filter_type === (int)$t['id'] ? 'selected' : '' ?>>
              <?= e($t['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-3">
        <label>Disponibilité</label>
        <select name="status" class="form-control">
          <option value="">Tous</option>
          <option value="disponible" <?= $filter_status === 'disponible' ? 'selected' : '' ?>>Disponible</option>
          <option value="reserve" <?= $filter_status === 'reserve' ? 'selected' : '' ?>>Réservé</option>
          <option value="vendu" <?= $filter_status === 'vendu' ? 'selected' : '' ?>>Vendu</option>
          <option value="bloque" <?= $filter_status === 'bloque' ? 'selected' : '' ?>>Bloqué</option>
        </select>
      </div>

      <div class="col-md-1 d-flex align-items-end">
        <button class="btn btn-primary w-100">
          <i class="fas fa-filter"></i>
        </button>
      </div>

    </form>
  </div>
</div>


<div class="card mb-3">
  <div class="card-body">
    <div class="row">
      <div class="col-md-4">
        <label>N° du lot</label>
        <input type="text"
               id="search-lot"
               class="form-control"
               placeholder="Rechercher par N° du lot">
      </div>
    </div>
  </div>
</div>


<?php
$queryString = http_build_query($_GET);
?>

<div class="mb-3">
  <a href="export_excel.php?<?= $queryString ?>" class="btn btn-success btn-sm">
    <i class="fas fa-file-excel"></i> Export Excel
  </a>

  <a href="export_pdf.php?<?= $queryString ?>" class="btn btn-danger btn-sm ml-2">
    <i class="fas fa-file-pdf"></i> Export PDF
  </a>
</div>



<!-- TABLE -->
<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Projet</th>
          <th>N° du lot</th>
          <th>Côté</th>
          <th>Type</th>
          <th>Surface</th>
          <th>Prix</th>
          <th>État</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody id="lots-results">

      <?php if (!$lots): ?>
        <tr>
          <td colspan="9" class="text-center text-muted p-4">Aucun lot</td>
        </tr>
      <?php else: foreach ($lots as $l): ?>
        <tr>
          <td><?= $l['id'] ?></td>
          <td><strong><?= e($l['project_name']) ?></strong></td>
          <td><?= e($l['reference']) ?></td>
          <td><?= $l['side'] === 'droite' ? 'À droite' : ($l['side'] === 'gauche' ? 'À gauche' : '-') ?></td>
          <td><?= e($l['lot_type']) ?></td>
          <td><?= number_format($l['surface'], 2) ?> m²</td>
          <td><?= number_format($l['price'], 0, ' ', ' ') ?> DA</td>
         <td>
  <span class="badge badge-<?=
    match ($l['status']) {
      'disponible' => 'success',
      'reserve'    => 'warning',
      'vendu'      => 'primary',
      'bloque'     => 'danger',
      default      => 'secondary'
    }
  ?>">
    <?= ucfirst(e($l['status'])) ?>
  </span>
</td>

          <td>
           <a href="<?= e(base_url('/public/lots/show.php?id='.$l['id'])) ?>" class="btn btn-sm btn-secondary">
                <i class="fas fa-eye"></i>
          </a><?php if ($l['status'] === 'disponible'): ?>
   
            <a href="<?= e(base_url('/public/simulations/create.php?lot_id='.$l['id'])) ?>"
               class="btn btn-sm btn-success"
               title="Créer une simulation">
               <i class="fas fa-calculator"></i>
            </a>
            
        <?php endif; ?>


 <a href="<?= e(base_url('/public/lots/edit.php?id='.$l['id'])) ?>" class="btn btn-sm btn-primary">
              <i class="fas fa-edit"></i>
            </a>
          </td>
        </tr>
      <?php endforeach; endif; ?>

      </tbody>
    </table>
  </div>
</div>

</div>


</section>
<script>
document.getElementById('search-lot').addEventListener('keyup', function () {
    const q = this.value;

    fetch('search.php?q=' + encodeURIComponent(q))
        .then(res => res.text())
        .then(html => {
            document.getElementById('lots-results').innerHTML = html;
        });
});
</script>
<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
