<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/config/database.php';

/* 🔴 ADAPTE CE CHEMIN SI BESOIN */
require_once __DIR__ . '/../../app/libs/fpdf/fpdf.php';
// ou fpdf/fpdf.php selon ton arborescence

/* =====================
   FILTRES
   ===================== */
$project_id  = (int)($_GET['project_id'] ?? 0);
$lot_type_id = (int)($_GET['lot_type_id'] ?? 0);
$status      = $_GET['status'] ?? '';

$where  = [];
$params = [];

if ($project_id > 0) {
    $where[] = 'l.project_id = ?';
    $params[] = $project_id;
}
if ($lot_type_id > 0) {
    $where[] = 'l.lot_type_id = ?';
    $params[] = $lot_type_id;
}
if ($status !== '') {
    $where[] = 'l.status = ?';
    $params[] = $status;
}

$sql = "
SELECT
    p.name AS projet,
    l.reference,
    l.side,
    lt.name AS type,
    l.surface,
    l.price,
    l.status
FROM lots l
LEFT JOIN projects p   ON p.id = l.project_id
LEFT JOIN lot_types lt ON lt.id = l.lot_type_id
" . ($where ? ' WHERE ' . implode(' AND ', $where) : '') . "
ORDER BY l.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* =====================
   PDF
   ===================== */
$pdf = new FPDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0,10,'Liste des lots',0,1,'C');
$pdf->Ln(4);

$pdf->SetFont('Arial','B',9);
$headers = ['Projet','Lot','Côté','Type','Surface','Prix','Statut'];
$widths  = [45,30,25,35,25,35,30];

foreach ($headers as $i => $h) {
    $pdf->Cell($widths[$i],7,$h,1,0,'C');
}
$pdf->Ln();

$pdf->SetFont('Arial','',9);

foreach ($rows as $r) {
    $pdf->Cell($widths[0],7,$r['projet'],1);
    $pdf->Cell($widths[1],7,$r['reference'],1);
    $pdf->Cell($widths[2],7,$r['side'],1);
    $pdf->Cell($widths[3],7,$r['type'],1);
    $pdf->Cell($widths[4],7,$r['surface'].' m²',1);
    $pdf->Cell($widths[5],7,number_format($r['price'],0,' ',' ').' DA',1);
    $pdf->Cell($widths[6],7,$r['status'],1);
    $pdf->Ln();
}

$pdf->Output('D', 'lots_' . date('Ymd_His') . '.pdf');
exit;
