<?php
require_once __DIR__ . '/../../app/config/database.php';

/* =====================
   FILTRES
   ===================== */
$project_id = (int)($_GET['project_id'] ?? 0);
$lot_type_id = (int)($_GET['lot_type_id'] ?? 0);
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($project_id > 0) {
    $where[] = 'l.project_id = ?';
    $params[] = $project_id;
}

if ($lot_type_id > 0) {
    $where[] = 'l.lot_type_id = ?';
    $params[] = $lot_type_id;
}

if ($status !== '') {
    $where[] = 'l.status = ?';
    $params[] = $status;
}

$sql = "
SELECT
    p.name AS projet,
    l.reference AS lot,
    l.side,
    lt.name AS type,
    l.surface,
    l.price,
    l.status
FROM lots l
LEFT JOIN projects p   ON p.id = l.project_id
LEFT JOIN lot_types lt ON lt.id = l.lot_type_id
" . ($where ? ' WHERE ' . implode(' AND ', $where) : '') . "
ORDER BY l.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* =====================
   HEADERS EXCEL
   ===================== */
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=lots_" . date('Ymd_His') . ".xls");

echo "Projet\tLot\tC00t\tType\tSurface\tPrix\tStatut\n";

foreach ($rows as $r) {
    echo implode("\t", [
        $r['projet'],
        $r['lot'],
        $r['side'],
        $r['type'],
        $r['surface'],
        $r['price'],
        $r['status']
    ]) . "\n";
}
