<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('/public/lots/index.php');

// Données
$projects = $pdo->query("SELECT id, name FROM projects ORDER BY name")->fetchAll();
$types    = $pdo->query("SELECT id, name FROM lot_types ORDER BY name")->fetchAll();

$stmt = $pdo->prepare("SELECT * FROM lots WHERE id = ?");
$stmt->execute([$id]);
$lot = $stmt->fetch();
if (!$lot) redirect('/public/lots/index.php');

$title = "Modifier un lot";
$active = 'lots';
$subactive = 'lots_all';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $project_id  = (int)$_POST['project_id'];
    $lot_type_id = (int)$_POST['lot_type_id'];
    $reference   = trim($_POST['reference']);
    $floor       = ($_POST['floor'] === '' ? null : (int)$_POST['floor']);
    $surface     = (float)$_POST['surface'];
    $price       = ($_POST['price'] === '' ? null : (float)$_POST['price']);
    $status      = $_POST['status'];

    if ($project_id <= 0 || $lot_type_id <= 0 || $reference === '' || $surface <= 0) {
        $errors[] = "Tous les champs obligatoires doivent être valides.";
    }

    if (!$errors) {
        $stmt = $pdo->prepare("
            UPDATE lots SET
              project_id=?, lot_type_id=?, reference=?, floor=?, surface=?, price=?, status=?
            WHERE id=?
        ");
        $stmt->execute([
            $project_id, $lot_type_id, $reference, $floor, $surface, $price, $status, $id
        ]);

        redirect('/public/lots/index.php');
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">
<div class="card">
  <div class="card-header"><h3 class="card-title">Modifier le lot</h3></div>
  <div class="card-body">

<?php if ($errors): ?>
<div class="alert alert-danger"><ul><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul></div>
<?php endif; ?>

<form method="post">
<div class="row">
  <div class="col-md-6">
    <label>Projet *</label>
    <select name="project_id" class="form-control">
      <?php foreach ($projects as $p): ?>
        <option value="<?= $p['id'] ?>" <?= $p['id']==$lot['project_id']?'selected':'' ?>><?= e($p['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>

  <div class="col-md-6">
    <label>Type de lot *</label>
    <select name="lot_type_id" class="form-control">
      <?php foreach ($types as $t): ?>
        <option value="<?= $t['id'] ?>" <?= $t['id']==$lot['lot_type_id']?'selected':'' ?>><?= e($t['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</div>

<div class="row mt-2">
  <div class="col-md-3"><label>Référence</label><input name="reference" class="form-control" value="<?= e($lot['reference']) ?>"></div>
  <div class="col-md-3"><label>Étage</label><input name="floor" class="form-control" value="<?= e($lot['floor']) ?>"></div>
  <div class="col-md-3"><label>Surface</label><input name="surface" class="form-control" value="<?= e($lot['surface']) ?>"></div>
  <div class="col-md-3"><label>Prix</label><input name="price" class="form-control" value="<?= e($lot['price']) ?>"></div>
</div>

<div class="mt-2">
  <label>Statut</label>
  <select name="status" class="form-control">
    <?php foreach (['disponible','reserve','vendu','bloque'] as $s): ?>
      <option value="<?= $s ?>" <?= $lot['status']===$s?'selected':'' ?>><?= ucfirst($s) ?></option>
    <?php endforeach; ?>
  </select>
</div>

<button class="btn btn-success mt-3"><i class="fas fa-save"></i> Enregistrer</button>
<a href="<?= e(base_url('/public/lots/index.php')) ?>" class="btn btn-secondary mt-3 ml-2">Retour</a>
</form>

</div></div></div></section>
<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
