<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager']);

$errors = [];

/* =====================
   Charger projets
   ===================== */
$projects = $pdo->query("
    SELECT id, name
    FROM projects
    ORDER BY name ASC
")->fetchAll();

/* =====================
   Charger types de lots
   ===================== */
$lot_types = $pdo->query("
    SELECT id, name
    FROM lot_types
    ORDER BY name ASC
")->fetchAll();

/* =====================
   TRAITEMENT FORMULAIRE
   ===================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $project_id  = (int)($_POST['project_id'] ?? 0);
    $lot_type_id = (int)($_POST['lot_type_id'] ?? 0);
    $reference   = trim($_POST['reference'] ?? '');
    $side = $_POST['side'] ?? null;
    $floor       = ($_POST['floor'] !== '') ? (int)$_POST['floor'] : null;
    $surface     = (float)($_POST['surface'] ?? 0);
    $price       = (float)($_POST['price'] ?? 0);

    if ($project_id <= 0)  $errors[] = "Projet obligatoire.";
    if ($lot_type_id <= 0) $errors[] = "Type de lot obligatoire.";
    if ($reference === '') $errors[] = "Référence obligatoire.";
    if ($surface <= 0)     $errors[] = "Surface invalide.";
    if ($price <= 0)       $errors[] = "Prix invalide.";

    if (!$errors) {
       $stmt = $pdo->prepare("
    INSERT INTO lots
    (project_id, lot_type_id, reference, side, floor, surface, price, status)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)
");
$stmt->execute([
    $project_id,
    $lot_type_id,
    $reference,
    $side,
    $floor,
    $surface,
    $price,
    'disponible'
]);


        redirect('/public/lots/index.php');
    }
}

$title  = "Ajouter un lot";
$active = 'lots';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card card-outline card-primary">
  <div class="card-header">
    <h3 class="card-title">
      <i class="fas fa-plus"></i> Ajouter un lot
    </h3>
  </div>

  <div class="card-body">

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach ($errors as $e): ?>
            <li><?= e($e) ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post">

      <div class="form-group">
        <label>Projet</label>
        <select name="project_id" class="form-control" required>
          <option value="">— Sélectionner —</option>
          <?php foreach ($projects as $p): ?>
            <option value="<?= $p['id'] ?>"><?= e($p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="form-group">
        <label>Type de lot</label>
        <select name="lot_type_id" class="form-control" required>
          <option value="">— Sélectionner —</option>
          <?php foreach ($lot_types as $t): ?>
            <option value="<?= $t['id'] ?>"><?= e($t['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="form-group">
        <label>N° du lot *</label>
        <input type="text" name="reference" class="form-control" required>
      </div>
        
        <div class="col-md-4">
            <div class="form-group">
                <label>Côté</label>
                <select name="side" class="form-control">
                    <option value="">-- Choisir --</option>
                    <option value="droite" <?= ($_POST['side'] ?? '') === 'droite' ? 'selected' : '' ?>>
                        À droite
                    </option>
                    <option value="gauche" <?= ($_POST['side'] ?? '') === 'gauche' ? 'selected' : '' ?>>
                        À gauche
                    </option>
                </select>
            </div>
        </div>


      <div class="form-group">
        <label>Étage</label>
        <input type="number" name="floor" class="form-control">
      </div>

      <div class="form-group">
        <label>Surface (m²)</label>
        <input type="number" step="0.01" name="surface" class="form-control" required>
      </div>

      <div class="form-group">
        <label>Prix (DA)</label>
        <input type="number" step="0.01" name="price" class="form-control" required>
      </div>

      <div class="mt-3">
        <button class="btn btn-success">
          <i class="fas fa-save"></i> Enregistrer
        </button>

        <a href="<?= e(base_url('/public/lots/index.php')) ?>" class="btn btn-secondary">
          Annuler
        </a>
      </div>

    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
