<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Types de lots | IMMOTECH";
$active = 'projects';
$subactive = 'lot_types';

// Récupération
$stmt = $pdo->query("SELECT * FROM lot_types ORDER BY id DESC");
$types = $stmt->fetchAll();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between mb-3">
  <h3>Types de lots</h3>
  <a href="<?= e(base_url('/public/lot-types/create.php')) ?>" class="btn btn-primary">
    <i class="fas fa-plus"></i> Ajouter
  </a>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover">
      <thead>
        <tr>
          <th>ID</th>
          <th>Dénomination</th>
          <th>Description standard</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$types): ?>
        <tr><td colspan="4" class="text-center text-muted p-4">Aucun type de lot.</td></tr>
      <?php else: ?>
        <?php foreach ($types as $t): ?>
          <tr>
            <td><?= (int)$t['id'] ?></td>
            <td><strong><?= e($t['name']) ?></strong></td>
            <td><?= e($t['description']) ?></td>
            <td>
              <a href="<?= e(base_url('/public/lot-types/edit.php?id=' . $t['id'])) ?>"
                 class="btn btn-sm btn-warning">
                <i class="fas fa-edit"></i>
              </a>
              <a href="<?= e(base_url('/public/lot-types/delete.php?id=' . $t['id'])) ?>"
                 onclick="return confirm('Supprimer ce type de lot ?')"
                 class="btn btn-sm btn-danger">
                <i class="fas fa-trash"></i>
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
