<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title = "Ajouter un type de lot";
$active = 'projects';
$subactive = 'lot_types';

$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');

    if ($name === '') {
        $errors[] = "La dénomination est obligatoire.";
    }

    if (!$errors) {
        try {
            $stmt = $pdo->prepare("INSERT INTO lot_types (name, description) VALUES (?, ?)");
            $stmt->execute([$name, $description]);
            $success = true;
        } catch (PDOException $e) {
            $errors[] = "Ce type de lot existe déjà.";
        }
    }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header"><h3 class="card-title">Ajouter un type de lot</h3></div>
  <div class="card-body">

    <?php if ($success): ?>
      <div class="alert alert-success">
        ✅ Type de lot ajouté.
        <a href="<?= e(base_url('/public/lot-types/index.php')) ?>" class="alert-link ml-2">Retour</a>
      </div>
    <?php endif; ?>

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post">
      <div class="form-group">
        <label>Dénomination *</label>
        <input type="text" name="name" class="form-control" required>
      </div>

      <div class="form-group">
        <label>Description standard</label>
        <textarea name="description" class="form-control" rows="3"></textarea>
      </div>

      <button class="btn btn-success"><i class="fas fa-save"></i> Enregistrer</button>
      <a href="<?= e(base_url('/public/lot-types/index.php')) ?>" class="btn btn-secondary ml-2">Annuler</a>
    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
