<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) redirect('/public/reservations/index.php');

try {
  $pdo->beginTransaction();

  // lock échéance
  $st = $pdo->prepare("SELECT * FROM installments WHERE id=? FOR UPDATE");
  $st->execute([$id]);
  $ins = $st->fetch();
  if (!$ins) throw new Exception("Échéance introuvable.");
  if ($ins['status'] === 'paid') throw new Exception("Déjà payée.");

  // créer payment (méthode par défaut virement, tu peux faire un formulaire après)
  $payment = $pdo->prepare("
    INSERT INTO payments (reservation_id, amount, payment_date, method, reference)
    VALUES (?, ?, CURDATE(), 'virement', ?)
  ");
  $ref = 'ECH-'.$ins['id'];
  $payment->execute([$ins['reservation_id'], $ins['amount'], $ref]);
  $payment_id = (int)$pdo->lastInsertId();

  // marquer échéance payée
  $up = $pdo->prepare("
    UPDATE installments
    SET status='paid', paid_at=NOW(), payment_id=?
    WHERE id=?
  ");
  $up->execute([$payment_id, $id]);

  $pdo->commit();

  redirect('/public/installments/index.php?reservation_id='.$ins['reservation_id']);

} catch (Exception $e) {
  $pdo->rollBack();
  redirect('/public/reservations/index.php?err=' . urlencode($e->getMessage()));
}
