<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$reservation_id = (int)($_GET['reservation_id'] ?? 0);
if ($reservation_id <= 0) redirect('/public/reservations/index.php');

// infos réservation + lot
$stmt = $pdo->prepare("
  SELECT r.id, r.status, l.reference, s.final_price
  FROM reservations r
  JOIN lots l ON l.id=r.lot_id
  JOIN simulations s ON s.id=r.simulation_id
  WHERE r.id=?
");
$stmt->execute([$reservation_id]);
$info = $stmt->fetch();
if (!$info) redirect('/public/reservations/index.php');

$stmt = $pdo->prepare("SELECT * FROM installments WHERE reservation_id=? ORDER BY due_date ASC");
$stmt->execute([$reservation_id]);
$items = $stmt->fetchAll();

$title = "Échéancier";
$active = 'payments';
include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">
<div class="d-flex justify-content-between mb-3">
  <h3>Échéancier — Lot <?= e($info['reference']) ?></h3>
  <a class="btn btn-secondary" href="<?= e(base_url('/public/reservations/index.php')) ?>">Retour</a>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover">
      <thead>
        <tr>
          <th>Date échéance</th>
          <th>Montant</th>
          <th>Statut</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$items): ?>
        <tr><td colspan="4" class="text-center text-muted p-4">Aucune échéance.</td></tr>
      <?php else: foreach ($items as $it): ?>
        <tr>
          <td><?= e(date('d/m/Y', strtotime($it['due_date']))) ?></td>
          <td><?= number_format($it['amount'], 2, ',', ' ') ?> DA</td>
          <td><?= e($it['status']) ?></td>
          <td>
            <?php if ($it['status'] === 'due'): ?>
              <a class="btn btn-sm btn-success"
                 href="<?= e(base_url('/public/installments/pay.php?id='.$it['id'])) ?>"
                 onclick="return confirm('Marquer cette échéance comme payée ?');">
                 Payer
              </a>
            <?php else: ?>
              —
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
