<?php
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','marketing']);

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    die('Accès refusé');
}

$stmt = $pdo->prepare("
    SELECT document_path, document_name
    FROM fournisseur_offres
    WHERE id = ?
");
$stmt->execute([$id]);
$offre = $stmt->fetch();

if (!$offre || empty($offre['document_path'])) {
    die('Facture introuvable');
}

$filePath = __DIR__ . '/../../../' . $offre['document_path'];

if (!file_exists($filePath)) {
    die('Fichier manquant sur le serveur');
}

header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="'.basename($offre['document_name'] ?: 'facture.pdf').'"');
header('Content-Length: ' . filesize($filePath));

readfile($filePath);
exit;
