<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','marketing']);

$offre_id = (int)($_POST['offre_id'] ?? 0);
$document_name = trim($_POST['document_name'] ?? '');

if ($offre_id <= 0 || empty($_FILES['facture'])) {
    die('Données invalides');
}

$file = $_FILES['facture'];

if ($file['error'] !== UPLOAD_ERR_OK) {
    die('Erreur upload fichier');
}

/* Vérification PDF */
$ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
if ($ext !== 'pdf') {
    die('Seuls les fichiers PDF sont autorisés');
}

/* Dossier stockage */
$storageDir = __DIR__ . '/../../../storage/fournisseurs/offres/';
if (!is_dir($storageDir)) {
    mkdir($storageDir, 0775, true);
}

/* Nom physique sécurisé */
$filename = 'offre_' . $offre_id . '_' . time() . '.pdf';
$fullPath = $storageDir . $filename;

/* Déplacement */
if (!move_uploaded_file($file['tmp_name'], $fullPath)) {
    die('Impossible de sauvegarder le fichier');
}

/* Chemin relatif */
$relativePath = 'storage/fournisseurs/offres/' . $filename;

/* Nom lisible par défaut */
if ($document_name === '') {
    $document_name = 'Facture offre #' . $offre_id;
}

/* Sauvegarde BDD */
$stmt = $pdo->prepare("
    UPDATE fournisseur_offres
    SET document_path = ?, document_name = ?, status = 'soumise'
    WHERE id = ?
");
$stmt->execute([$relativePath, $document_name, $offre_id]);

redirect('/public/fournisseurs/offres/show.php?id='.$offre_id);
