<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','marketing']);

$fournisseur_name = trim($_POST['fournisseur_name'] ?? '');
$title            = trim($_POST['title'] ?? '');
$description      = trim($_POST['description'] ?? '');
$amount           = (float)($_POST['amount'] ?? 0);
$comment          = trim($_POST['comment'] ?? '');

if ($fournisseur_name === '' || $title === '' || $amount <= 0) {
    redirect('/public/fournisseurs/offres/create.php');
}

$stmt = $pdo->prepare("
    INSERT INTO fournisseur_offres
    (fournisseur_name, title, description, amount, currency, status, comment)
    VALUES (?, ?, ?, ?, 'DZD', 'brouillon', ?)
");

$stmt->execute([
    $fournisseur_name,
    $title,
    $description,
    $amount,
    $comment
]);

redirect('/public/fournisseurs/offres/index.php');
