<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','marketing']);

$title  = "Détail offre fournisseur";
$active = 'fournisseurs';

/******************** ID ********************/
$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    redirect('/public/fournisseurs/offres/index.php');
}

/******************** OFFRE ********************/
$stmt = $pdo->prepare("
    SELECT *
    FROM fournisseur_offres
    WHERE id = ?
");
$stmt->execute([$id]);
$offre = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$offre) {
    redirect('/public/fournisseurs/offres/index.php');
}

include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Détail de l’offre fournisseur</h3>
  <a class="btn btn-secondary"
     href="<?= e(base_url('/public/fournisseurs/offres/index.php')) ?>">
    <i class="fas fa-arrow-left"></i> Retour
  </a>
</div>

<!-- ================= ACTIONS EN HAUT ================= -->
<?php if (Permissions::can(['admin','director','manager'])): ?>

  <!-- SOUMISE -->
  <?php if ($offre['status'] === 'soumise'): ?>
    <form method="POST" action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>" class="d-inline">
      <input type="hidden" name="id" value="<?= $offre['id'] ?>">
      <input type="hidden" name="status" value="acceptee">
      <button class="btn btn-success">Accepter</button>
    </form>

    <form method="POST" action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>" class="d-inline ml-2">
      <input type="hidden" name="id" value="<?= $offre['id'] ?>">
      <input type="hidden" name="status" value="refusee">
      <button class="btn btn-danger">Refuser</button>
    </form>
  <?php endif; ?>

  <!-- ACCEPTÉE -->
  <?php if ($offre['status'] === 'acceptee'): ?>
    <form method="POST" action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>">
      <input type="hidden" name="id" value="<?= $offre['id'] ?>">
      <input type="hidden" name="status" value="en_cours">
      <button class="btn btn-primary">Passer en cours</button>
    </form>
  <?php endif; ?>

  <!-- EN COURS -->
  <?php if ($offre['status'] === 'en_cours'): ?>
    <form method="POST" action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>">
      <input type="hidden" name="id" value="<?= $offre['id'] ?>">
      <input type="hidden" name="status" value="terminee">
      <button class="btn btn-warning">Marquer terminée</button>
    </form>
  <?php endif; ?>

  <!-- TERMINÉE -->
  <?php if ($offre['status'] === 'terminee'): ?>
    <form method="POST" action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>">
      <input type="hidden" name="id" value="<?= $offre['id'] ?>">
      <input type="hidden" name="status" value="cloturee">
      <button class="btn btn-dark">Clôturer</button>
    </form>
  <?php endif; ?>

<?php endif; ?>


<!-- ================= 2 COLONNES ================= -->
<div class="row">

  <!-- ===== COLONNE GAUCHE : INFOS ===== -->
  <div class="col-md-7">
    <div class="card mb-4">
      <div class="card-body">

        <strong>Fournisseur</strong><br>
        <?= e($offre['fournisseur_name']) ?><hr>

        <strong>Statut</strong><br>
<span class="badge badge-secondary">
  <?= ucfirst(e($offre['status'])) ?>
</span>
        <?php if (!empty($offre['validated_at'])): ?>
          <div class="text-muted mt-1">
            Dernière action le <?= date('d/m/Y H:i', strtotime($offre['validated_at'])) ?>
          </div>
        <?php endif; ?>
        <hr>

        <strong>Titre</strong><br>
        <?= e($offre['title']) ?><br><br>

        <strong>Montant</strong><br>
        <?= number_format($offre['amount'],2,',',' ') ?> DZD<br><br>

        <strong>Description</strong>
        <div class="border rounded p-2 bg-light">
          <?= nl2br(e($offre['description'] ?? '—')) ?>
        </div><br>

        <strong>Commentaire</strong>
        <div class="border rounded p-2 bg-light">
          <?= nl2br(e($offre['comment'] ?? '—')) ?>
        </div>

      </div>
    </div>
  </div>

  <!-- ===== COLONNE DROITE : FACTURE ===== -->
  <div class="col-md-5">
    <div class="card mb-4">
      <div class="card-header">
        <strong>Facture fournisseur</strong>
      </div>

      <div class="card-body">

        <?php if (!empty($offre['document_path'])): ?>
          <a class="btn btn-outline-info mb-3"
             target="_blank"
             href="<?= e(base_url('/public/fournisseurs/offres/view_facture.php?id='.$offre['id'])) ?>">
            <i class="fas fa-file-pdf"></i>
            <?= e($offre['document_name'] ?? 'Consulter la facture') ?>
          </a>
        <?php else: ?>
          <p class="text-muted">Aucune facture jointe</p>
        <?php endif; ?>

        <?php if (
            Permissions::can(['admin','director','manager','marketing'])
            && in_array($offre['status'], ['brouillon','soumise'])
        ): ?>
        <form method="POST"
              enctype="multipart/form-data"
              action="<?= e(base_url('/public/fournisseurs/offres/upload_facture.php')) ?>">

          <input type="hidden" name="offre_id" value="<?= (int)$offre['id'] ?>">

          <div class="mb-2">
            <input class="form-control"
                   name="document_name"
                   placeholder="Nom de la facture">
          </div>

          <div class="mb-2">
            <input type="file"
                   name="facture"
                   accept="application/pdf"
                   class="form-control"
                   required>
          </div>

          <button class="btn btn-primary btn-block">
            <i class="fas fa-upload"></i> Joindre la facture
          </button>
        </form>
        <?php endif; ?>

      </div>
    </div>
  </div>

</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
