<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

/******************** INCLUDES ********************/
require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','marketing']);

$title  = "Offres fournisseurs";
$active = 'fournisseurs';

/******************** FILTRES ********************/
$status = trim($_GET['status'] ?? '');
$q      = trim($_GET['q'] ?? '');

$where  = [];
$params = [];

if ($status !== '') {
    $where[]  = "status = ?";
    $params[] = $status;
}

if ($q !== '') {
    $where[] = "(fournisseur_name LIKE ? OR title LIKE ?)";
    $like = "%$q%";
    $params[] = $like;
    $params[] = $like;
}

/******************** REQUÊTE ********************/
$sql = "
SELECT *
FROM fournisseur_offres
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$offres = $stmt->fetchAll(PDO::FETCH_ASSOC);

/******************** LAYOUT ********************/
include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ================= HEADER ================= -->
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Offres fournisseurs</h3>

  <a class="btn btn-success"
     href="<?= e(base_url('/public/fournisseurs/offres/create.php')) ?>">
    <i class="fas fa-plus"></i> Nouvelle offre
  </a>
</div>

<!-- ================= FILTRES ================= -->
<div class="card mb-3">
  <div class="card-body">
    <form class="row" method="get">

      <div class="col-md-4">
        <input class="form-control"
               name="q"
               value="<?= e($q) ?>"
               placeholder="Recherche fournisseur / offre">
      </div>

      <div class="col-md-3">
        <select class="form-control" name="status">
          <option value="">— Statut —</option>
          <?php foreach (['brouillon','soumise','acceptee','refusee','en_cours','terminee','cloturee'] as $s): ?>
            <option value="<?= $s ?>" <?= $status === $s ? 'selected' : '' ?>>
              <?= ucfirst($s) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-2">
        <button class="btn btn-primary w-100">
          <i class="fas fa-search"></i>
        </button>
      </div>

    </form>
  </div>
</div>

<!-- ================= TABLE ================= -->
<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Fournisseur</th>
          <th>Offre</th>
          <th class="text-right">Montant (DZD)</th>
          <th>Statut</th>
          <th>Facture</th>
          <th class="text-nowrap">Actions</th>
        </tr>
      </thead>

      <tbody>
      <?php if (!$offres): ?>
        <tr>
          <td colspan="7" class="text-center text-muted p-4">
            Aucune offre fournisseur.
          </td>
        </tr>
      <?php else: foreach ($offres as $o): ?>
        <tr>
          <td><?= (int)$o['id'] ?></td>
          <td><?= e($o['fournisseur_name']) ?></td>
          <td><?= e($o['title']) ?></td>

          <td class="text-right font-weight-bold">
            <?= number_format($o['amount'], 2, ',', ' ') ?>
          </td>

          <td>
            <?= function_exists('badge_status')
                ? badge_status($o['status'])
                : '<span class="badge badge-secondary">'.ucfirst(e($o['status'])).'</span>' ?>
          </td>

          <td>
            <?php if (!empty($o['document_path'])): ?>
              <a href="<?= e(base_url('/public/fournisseurs/offres/view_facture.php?id='.$o['id'])) ?>"
                 target="_blank"
                 class="btn btn-sm btn-outline-info"
                 title="Voir facture">
                 <i class="fas fa-file-pdf"></i>
              </a>
            <?php else: ?>
              <span class="text-muted">—</span>
            <?php endif; ?>
          </td>

          <!-- ================= ACTIONS ================= -->
          <td class="text-nowrap">

            <!-- VOIR -->
            <a class="btn btn-sm btn-secondary"
               title="Détails"
               href="<?= e(base_url('/public/fournisseurs/offres/show.php?id='.$o['id'])) ?>">
              <i class="fas fa-eye"></i>
            </a>

            <!-- SOUMISE -->
            <?php if (
                $o['status'] === 'soumise'
                && Permissions::can(['admin','director','manager'])
            ): ?>
              <form method="POST"
                    action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>"
                    class="d-inline">
                <input type="hidden" name="id" value="<?= $o['id'] ?>">
                <input type="hidden" name="status" value="acceptee">
                <button class="btn btn-sm btn-success" title="Accepter">
                  <i class="fas fa-check"></i>
                </button>
              </form>

              <form method="POST"
                    action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>"
                    class="d-inline">
                <input type="hidden" name="id" value="<?= $o['id'] ?>">
                <input type="hidden" name="status" value="refusee">
                <button class="btn btn-sm btn-danger" title="Refuser">
                  <i class="fas fa-times"></i>
                </button>
              </form>
            <?php endif; ?>

            <!-- ACCEPTÉE -->
            <?php if (
                $o['status'] === 'acceptee'
                && Permissions::can(['admin','director','manager'])
            ): ?>
              <form method="POST"
                    action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>"
                    class="d-inline">
                <input type="hidden" name="id" value="<?= $o['id'] ?>">
                <input type="hidden" name="status" value="en_cours">
                <button class="btn btn-sm btn-primary" title="Passer en cours">
                  <i class="fas fa-play"></i>
                </button>
              </form>
            <?php endif; ?>

            <!-- EN COURS -->
            <?php if (
                $o['status'] === 'en_cours'
                && Permissions::can(['manager','director'])
            ): ?>
              <form method="POST"
                    action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>"
                    class="d-inline">
                <input type="hidden" name="id" value="<?= $o['id'] ?>">
                <input type="hidden" name="status" value="terminee">
                <button class="btn btn-sm btn-warning" title="Marquer terminée">
                  <i class="fas fa-flag-checkered"></i>
                </button>
              </form>
            <?php endif; ?>

            <!-- TERMINÉE -->
            <?php if (
                $o['status'] === 'terminee'
                && Permissions::can(['director','admin'])
            ): ?>
              <form method="POST"
                    action="<?= e(base_url('/public/fournisseurs/offres/change_status.php')) ?>"
                    class="d-inline">
                <input type="hidden" name="id" value="<?= $o['id'] ?>">
                <input type="hidden" name="status" value="cloturee">
                <button class="btn btn-sm btn-dark" title="Clôturer">
                  <i class="fas fa-lock"></i>
                </button>
              </form>
            <?php endif; ?>

          </td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
