<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','marketing']);

$title  = "Nouvelle offre fournisseur";
$active = 'fournisseurs';

include __DIR__ . '/../../../app/views/layout/header.php';
include __DIR__ . '/../../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Créer une offre fournisseur</h3>
  <a class="btn btn-secondary"
     href="<?= e(base_url('/public/fournisseurs/offres/index.php')) ?>">
    <i class="fas fa-arrow-left"></i> Retour
  </a>
</div>

<div class="card">
<form method="POST"
      action="<?= e(base_url('/public/fournisseurs/offres/store.php')) ?>">

<div class="card-body">

  <div class="mb-3">
    <label>Fournisseur <span class="text-danger">*</span></label>
    <input class="form-control"
           name="fournisseur_name"
           placeholder="Nom du fournisseur"
           required>
  </div>

  <div class="mb-3">
    <label>Titre de l’offre <span class="text-danger">*</span></label>
    <input class="form-control"
           name="title"
           placeholder="Ex : Vidéo salon ERA"
           required>
  </div>

  <div class="mb-3">
    <label>Description</label>
    <textarea class="form-control"
              name="description"
              rows="3"></textarea>
  </div>

  <div class="row">
    <div class="col-md-4 mb-3">
      <label>Montant (DZD) <span class="text-danger">*</span></label>
      <input class="form-control"
             type="number"
             step="0.01"
             name="amount"
             required>
    </div>

    <div class="col-md-4 mb-3">
      <label>Devise</label>
      <input class="form-control" value="DZD" readonly>
    </div>
  </div>

  <div class="mb-3">
    <label>Commentaire</label>
    <textarea class="form-control"
              name="comment"
              rows="2"
              placeholder="Accord interne, remarque…"></textarea>
  </div>

</div>

<div class="card-footer text-right">
  <button class="btn btn-success">
    <i class="fas fa-save"></i> Enregistrer
  </button>
</div>

</form>
</div>

</div>
</section>

<?php include __DIR__ . '/../../../app/views/layout/footer.php'; ?>
