<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../../app/core/helpers.php';
require_once __DIR__ . '/../../../app/core/Auth.php';
require_once __DIR__ . '/../../../app/config/database.php';
require_once __DIR__ . '/../../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','marketing']);

$id     = (int)($_POST['id'] ?? 0);
$status = $_POST['status'] ?? '';

if ($id <= 0) {
    redirect('/public/fournisseurs/offres/index.php');
}

/******************** OFFRE ********************/
$stmt = $pdo->prepare("
    SELECT status
    FROM fournisseur_offres
    WHERE id = ?
");
$stmt->execute([$id]);
$offre = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$offre) {
    redirect('/public/fournisseurs/offres/index.php');
}

/******************** TRANSITIONS AUTORISÉES ********************/
$transitions = [
    'soumise'  => ['acceptee','refusee'],
    'acceptee' => ['en_cours'],
    'en_cours' => ['terminee'],
    'terminee' => ['cloturee'],
];

$current = $offre['status'];

if (
    !isset($transitions[$current])
    || !in_array($status, $transitions[$current])
) {
    redirect('/public/fournisseurs/offres/show.php?id='.$id);
}

/******************** UPDATE ********************/
$stmt = $pdo->prepare("
    UPDATE fournisseur_offres
    SET status = ?, validated_by = ?, validated_at = NOW()
    WHERE id = ?
");
$stmt->execute([
    $status,
    Auth::user()['id'],
    $id
]);

redirect('/public/fournisseurs/offres/show.php?id='.$id);
