<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';

Auth::requireLogin();

$title  = "Dashboard | IMMOTECH";
$active = 'dashboard';

/* =====================
   KPI FINANCIERS
===================== */

// CA encaissé
$ca = $pdo->query("
    SELECT IFNULL(SUM(amount),0)
    FROM payments
")->fetchColumn();

// Total ventes (prix final)
$total_sales = $pdo->query("
    SELECT IFNULL(SUM(s.final_price),0)
    FROM reservations r
    JOIN simulations s ON s.id = r.simulation_id
    WHERE r.status = 'vendue'
")->fetchColumn();

$reste = max($total_sales - $ca, 0);

// Lots
$lots = $pdo->query("
    SELECT status, COUNT(*) total
    FROM lots
    GROUP BY status
")->fetchAll(PDO::FETCH_KEY_PAIR);

// CA mensuel
$monthly = $pdo->query("
    SELECT DATE_FORMAT(p.created_at,'%Y-%m') m, SUM(p.amount) t
    FROM payments p
    GROUP BY m
    ORDER BY m
")->fetchAll(PDO::FETCH_ASSOC);

// Performance commerciaux
$commercials = $pdo->query("
    SELECT
        u.name,
        IFNULL(SUM(pay.amount), 0) AS total
    FROM users u

    LEFT JOIN clients c
        ON c.owner_user_id = u.id

    LEFT JOIN simulations s
        ON s.client_id = c.id

    LEFT JOIN payment_orders po
        ON po.simulation_id = s.id

    LEFT JOIN payments pay
        ON pay.payment_order_id = po.id

    GROUP BY u.id
    ORDER BY total DESC
")->fetchAll(PDO::FETCH_ASSOC);


include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<style>
.kpi-card {
  border-radius: 12px;
  box-shadow: 0 1px 8px rgba(0,0,0,.08);
}
.kpi-icon {
  font-size: 32px;
  color: #057b95;
}
</style>

<section class="content pt-3">
<div class="container-fluid">

<!-- =====================
     KPI
===================== -->
<div class="row">

  <div class="col-md-3">
    <div class="card kpi-card">
      <div class="card-body">
        <div class="d-flex justify-content-between">
          <div>
            <h6>CA encaissé</h6>
            <h4><?= number_format($ca, 0, ' ', ' ') ?> DA</h4>
          </div>
          <i class="fas fa-coins kpi-icon"></i>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="card kpi-card">
      <div class="card-body">
        <div class="d-flex justify-content-between">
          <div>
            <h6>Reste à encaisser</h6>
            <h4><?= number_format($reste, 0, ' ', ' ') ?> DA</h4>
          </div>
          <i class="fas fa-hourglass-half kpi-icon"></i>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="card kpi-card">
      <div class="card-body">
        <div class="d-flex justify-content-between">
          <div>
            <h6>Lots vendus</h6>
            <h4><?= $lots['vendu'] ?? 0 ?></h4>
          </div>
          <i class="fas fa-home kpi-icon"></i>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="card kpi-card">
      <div class="card-body">
        <div class="d-flex justify-content-between">
          <div>
            <h6>Lots disponibles</h6>
            <h4><?= $lots['disponible'] ?? 0 ?></h4>
          </div>
          <i class="fas fa-building kpi-icon"></i>
        </div>
      </div>
    </div>
  </div>

</div>

<!-- =====================
     GRAPHIQUES
===================== -->
<div class="row mt-3">

  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h5>CA mensuel</h5>
      </div>
      <div class="card-body">
        <canvas id="caChart"></canvas>
      </div>
    </div>
  </div>

  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h5>Performance commerciaux</h5>
      </div>
      <div class="card-body">
        <?php foreach ($commercials as $c): ?>
          <div class="mb-2">
            <strong><?= e($c['name']) ?></strong><br>
            <?= number_format($c['total'], 0, ' ', ' ') ?> DA
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

</div>

</div>
</section>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const caData = <?= json_encode($monthly) ?>;

new Chart(document.getElementById('caChart'), {
  type: 'line',
  data: {
    labels: caData.map(i => i.m),
    datasets: [{
      label: 'CA (DA)',
      data: caData.map(i => i.t),
      borderColor: '#057b95',
      backgroundColor: 'rgba(5,123,149,.15)',
      fill: true,
      tension: .3
    }]
  }
});
</script>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
