<?php
require_once __DIR__ . '/../app/core/helpers.php';
require_once __DIR__ . '/../app/core/Auth.php';
require_once __DIR__ . '/../app/models/Stats.php';

Auth::requireLogin();

$title = "Dashboard | IMMOTECH";
$active = "dashboard";

$projects = Stats::projects();
$lotsAvailable = Stats::lotsAvailable();
$sales = Stats::sales();
$clients = Stats::clients();

include __DIR__ . '/../app/views/layout/header.php';
include __DIR__ . '/../app/views/layout/sidebar.php';
?>
<section class="content pt-3">
  <div class="container-fluid">
    <div class="row">
      <div class="col-lg-3 col-6">
        <div class="small-box bg-info">
          <div class="inner"><h3><?= (int)$projects ?></h3><p>Projets</p></div>
          <div class="icon"><i class="fas fa-project-diagram"></i></div>
          <a href="#" class="small-box-footer disabled">Détails (V2) <i class="fas fa-arrow-circle-right"></i></a>
        </div>
      </div>
      <div class="col-lg-3 col-6">
        <div class="small-box bg-success">
          <div class="inner"><h3><?= (int)$lotsAvailable ?></h3><p>Lots disponibles</p></div>
          <div class="icon"><i class="fas fa-building"></i></div>
          <a href="#" class="small-box-footer disabled">Détails (V2) <i class="fas fa-arrow-circle-right"></i></a>
        </div>
      </div>
      <div class="col-lg-3 col-6">
        <div class="small-box bg-warning">
          <div class="inner"><h3><?= (int)$clients ?></h3><p>Clients</p></div>
          <div class="icon"><i class="fas fa-users"></i></div>
          <a href="#" class="small-box-footer disabled">Détails (V2) <i class="fas fa-arrow-circle-right"></i></a>
        </div>
      </div>
      <div class="col-lg-3 col-6">
        <div class="small-box bg-danger">
          <div class="inner"><h3><?= (int)$sales ?></h3><p>Ventes / Réservations</p></div>
          <div class="icon"><i class="fas fa-file-invoice-dollar"></i></div>
          <a href="#" class="small-box-footer disabled">Détails (V2) <i class="fas fa-arrow-circle-right"></i></a>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="card-header"><h3 class="card-title">Bienvenue</h3></div>
      <div class="card-body">
        <p>✅ Authentification + layout AdminLTE OK.</p>
        <p>Prochaine étape : CRUD Projets & Lots + Réservation 7 jours + PDF ordre de versement.</p>
      </div>
    </div>
  </div>
</section>
<?php include __DIR__ . '/../app/views/layout/footer.php'; ?>
