<?php
/******************** CRON – EXPIRATION RÉSERVATIONS ********************/

require_once __DIR__ . '/../../app/config/database.php';

$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

try {

    $pdo->beginTransaction();

    /* ===============================
       RÉSERVATIONS À EXPIRER
       =============================== */
    $stmt = $pdo->prepare("
        SELECT id, lot_id
        FROM reservations
        WHERE status = 'confirmee'
          AND expires_at < NOW()
        FOR UPDATE
    ");
    $stmt->execute();
    $expired = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$expired) {
        echo "0 réservation(s) expirée(s)\n";
        $pdo->commit();
        exit;
    }

    $ids = array_column($expired, 'id');
    $lots = array_column($expired, 'lot_id');

    /* ===============================
       PASSER LES RÉSERVATIONS → EXPIREES
       =============================== */
    $inIds = implode(',', array_fill(0, count($ids), '?'));
    $pdo->prepare("
        UPDATE reservations
        SET status = 'expiree', updated_at = NOW()
        WHERE id IN ($inIds)
    ")->execute($ids);

    /* ===============================
       LIBÉRER LES LOTS
       =============================== */
    $inLots = implode(',', array_fill(0, count($lots), '?'));
    $pdo->prepare("
        UPDATE lots
        SET status = 'disponible'
        WHERE id IN ($inLots)
          AND status = 'reserve'
    ")->execute($lots);

    $pdo->commit();

    echo count($ids)." réservation(s) expirée(s)\n";

} catch (Exception $e) {
    $pdo->rollBack();
    echo "Erreur CRON : ".$e->getMessage()."\n";
}
