<?php
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';
require_once __DIR__ . '/../../app/core/Audit.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager']);

$client_id = (int)($_GET['id'] ?? 0);
if ($client_id <= 0) redirect('/public/clients/index.php');

$stmt = $pdo->prepare("SELECT * FROM clients WHERE id=?");
$stmt->execute([$client_id]);
$client = $stmt->fetch();
if (!$client) redirect('/public/clients/index.php');

$users = $pdo->query("SELECT id, name, role FROM users ORDER BY name ASC")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_owner = (int)($_POST['owner_user_id'] ?? 0);
    if ($new_owner > 0) {
        $u = $pdo->prepare("UPDATE clients SET owner_user_id=? WHERE id=?");
        $u->execute([$new_owner, $client_id]);

        Audit::log([
          'client_id' => $client_id,
          'commercial_id' => $new_owner,
          'action_type' => 'transfer_client',
          'entity_type' => 'client',
          'entity_id' => $client_id,
          'description' => 'Changement du commercial référent'
        ]);

        redirect('/public/clients/show.php?id='.$client_id);
    }
}

$title  = "Transférer client";
$active = 'clients';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header"><strong>Changer commercial référent</strong></div>
  <div class="card-body">
    <p><strong>Client :</strong> <?= e($client['first_name'].' '.$client['last_name']) ?></p>

    <form method="post">
      <div class="form-group">
        <label>Nouveau commercial</label>
        <select class="form-control" name="owner_user_id" required>
          <?php foreach($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>" <?= ((int)$client['owner_user_id']===(int)$u['id'])?'selected':'' ?>>
              <?= e($u['name']) ?> (<?= e($u['role']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <button class="btn btn-primary"><i class="fas fa-save"></i> Enregistrer</button>
      <a class="btn btn-secondary ml-2" href="<?= e(base_url('/public/clients/show.php?id='.$client_id)) ?>">Annuler</a>
    </form>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
