<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$client_id = (int)($_GET['id'] ?? 0);
if ($client_id <= 0) redirect('/public/clients/index.php');

/* =======================
   CLIENT
======================= */
$stmt = $pdo->prepare("
  SELECT c.*, u.name AS commercial
  FROM clients c
  LEFT JOIN users u ON u.id = c.owner_user_id
  WHERE c.id = ?
");
$stmt->execute([$client_id]);
$client = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$client) redirect('/public/clients/index.php');

/* =======================
   LOTS DU CLIENT
======================= */
$sql = "
SELECT
  l.id            AS lot_id,
  l.reference     AS lot_ref,
  l.status        AS lot_status,
  p.name          AS project_name,
  l.price         AS lot_price,

  IFNULL(SUM(pay.amount),0) AS total_paid

FROM reservations r
JOIN lots l ON l.id = r.lot_id
JOIN projects p ON p.id = l.project_id

LEFT JOIN payment_orders po ON po.lot_id = l.id
LEFT JOIN payments pay 
  ON pay.payment_order_id = po.id 
 AND pay.status = 'valide'

WHERE r.client_id = ?
GROUP BY l.id
ORDER BY l.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute([$client_id]);
$lots = $stmt->fetchAll(PDO::FETCH_ASSOC);

$title  = "Client | ".$client['fullname'];
$active = 'clients';

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<!-- ================= CLIENT ================= -->
<div class="card mb-3">
  <div class="card-body">
    <h4><?= e($client['fullname']) ?></h4>
    <p>
      📞 <?= e($client['phone'] ?? '-') ?> |
      📧 <?= e($client['email'] ?? '-') ?><br>
      👤 Commercial : <?= e($client['commercial'] ?? '-') ?><br>
      <strong>Statut :</strong>
      <span class="badge badge-<?= $client['status']==='client'?'success':'warning' ?>">
        <?= ucfirst($client['status']) ?>
      </span>
    </p>
  </div>
</div>

<!-- ================= LOTS ================= -->
<div class="card">
  <div class="card-header">
    <h5 class="mb-0">Lots du client</h5>
  </div>

  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>Lot</th>
          <th>Projet</th>
          <th>Statut</th>
          <th>Total payé</th>
          <th>Reste à payer</th>
          <th>Action</th>
        </tr>
      </thead>

      <tbody>
      <?php if (!$lots): ?>
        <tr>
          <td colspan="6" class="text-center text-muted p-3">
            Aucun lot associé à ce client
          </td>
        </tr>
      <?php else: foreach ($lots as $l): 
        $reste = max(0, $l['lot_price'] - $l['total_paid']);
      ?>
        <tr>
          <td><strong><?= e($l['lot_ref']) ?></strong></td>
          <td><?= e($l['project_name']) ?></td>
          <td>
            <span class="badge badge-<?=
              match($l['lot_status']) {
                'disponible'=>'secondary',
                'reserve'=>'warning',
                'vendu'=>'success',
                default=>'dark'
              }
            ?>">
              <?= ucfirst($l['lot_status']) ?>
            </span>
          </td>
          <td><?= number_format($l['total_paid'],0,' ',' ') ?> DA</td>
          <td>
            <?= $reste > 0 
              ? number_format($reste,0,' ',' ').' DA'
              : '<span class="text-success">Soldé</span>' ?>
          </td>
          <td>
            <a href="<?= e(base_url('/public/lots/show.php?id='.$l['lot_id'])) ?>"
               class="btn btn-sm btn-secondary">
              <i class="fas fa-eye"></i>
            </a>
          </td>
        </tr>
      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
