<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';
require_once __DIR__ . '/../../app/core/ClientStatus.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Clients | IMMOTECH";
$active = 'clients';

$q     = trim($_GET['q'] ?? '');
$owner = (int)($_GET['owner'] ?? 0);

$where = [];
$params = [];

if ($q !== '') {
    $where[] = "(c.fullname LIKE ? OR c.phone LIKE ? OR c.email LIKE ?)";
    $like = "%$q%";
    $params[] = $like;
    $params[] = $like;
    $params[] = $like;
}

if ($owner > 0) {
    $where[] = "c.owner_user_id = ?";
    $params[] = $owner;
}

$sql = "
SELECT c.*, u.name AS owner_name
FROM clients c
JOIN users u ON u.id = c.owner_user_id
" . ($where ? " WHERE " . implode(" AND ", $where) : "") . "
ORDER BY c.id DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$clients = $stmt->fetchAll();

$users = $pdo->query("SELECT id, name, role FROM users ORDER BY name ASC")->fetchAll();

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">Liste des prospects et clients</h3>
  <?php if (Permissions::can(['admin','director','manager','commercial'])): ?>
    <a class="btn btn-success" href="<?= e(base_url('/public/clients/create.php')) ?>">
      <i class="fas fa-plus"></i> Ajouter un nouveau prospect
    </a>
  <?php endif; ?>
</div>

<div class="card mb-3">
  <div class="card-body">
    <form class="row" method="get">
      <div class="col-md-6">
        <input class="form-control" name="q" value="<?= e($q) ?>" placeholder="Recherche (nom, téléphone, email)">
      </div>
      <div class="col-md-4">
        <select class="form-control" name="owner">
          <option value="0">— Commercial référent —</option>
          <?php foreach ($users as $u): ?>
            <option value="<?= (int)$u['id'] ?>" <?= $owner === (int)$u['id'] ? 'selected' : '' ?>>
              <?= e($u['name']) ?> (<?= e($u['role']) ?>)
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100"><i class="fas fa-search"></i></button>
      </div>
    </form>
  </div>
</div>

<div class="card">
  <div class="card-body table-responsive p-0">
    <table class="table table-hover mb-0">
      <thead>
        <tr>
          <th>#</th>
          <th>Client</th>
          <th>Téléphone</th>
          <th>Email</th>
          <th>Statut</th>
          <th>Commercial</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
      <?php if (!$clients): ?>
        <tr><td colspan="7" class="text-center text-muted p-4">Aucun client.</td></tr>
      <?php else: foreach ($clients as $c): ?>
       <tr>
          <td><?= (int)$c['id'] ?></td>
          <td><?= e($c['fullname']) ?></td>
          <td><?= e($c['phone'] ?? '-') ?></td>
          <td><?= e($c['email'] ?? '-') ?></td>
        
          <td>
            <span class="badge badge-<?= $c['status'] === 'client' ? 'success' : 'warning' ?>">
              <?= ucfirst($c['status']) ?>
            </span>
          </td>
        
          <td><?= e($c['owner_name']) ?></td>
        
          <td>
            <a class="btn btn-sm btn-secondary"
               href="<?= e(base_url('/public/clients/show.php?id='.$c['id'])) ?>">
              <i class="fas fa-eye"></i> Détails
            </a>
          </td>
        </tr>

      <?php endforeach; endif; ?>
      </tbody>
    </table>
  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
