<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/Auth.php';
require_once __DIR__ . '/../../app/config/database.php';
require_once __DIR__ . '/../../app/core/Permissions.php';

Auth::requireLogin();
Permissions::allow(['admin','director','manager','commercial','finance']);

$title  = "Ajouter client | IMMOTECH";
$active = 'clients';

$userRole = $_SESSION['user']['role'] ?? 'commercial';
$userId   = (int)($_SESSION['user']['id'] ?? 0);

$errors = [];

/* Liste des utilisateurs assignables */
$users = $pdo->query("
  SELECT id, name, role
  FROM users
  ORDER BY name ASC
")->fetchAll();

/* Valeurs par défaut */
$data = [
  'fullname'      => '',
  'phone'         => '',
  'email'         => '',
  'city'          => '',
  'owner_user_id' => ($userRole === 'commercial' ? $userId : 0),
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $data['fullname'] = trim($_POST['fullname'] ?? '');
  $data['phone']    = trim($_POST['phone'] ?? '');
  $data['email']    = trim($_POST['email'] ?? '');
  $data['city']     = trim($_POST['city'] ?? '');

  if ($userRole === 'commercial') {
    $data['owner_user_id'] = $userId;
  } else {
    $data['owner_user_id'] = (int)($_POST['owner_user_id'] ?? 0);
  }

  /* Validations */
  if ($data['fullname'] === '') {
    $errors[] = "Nom complet obligatoire.";
  }

  if ($data['owner_user_id'] <= 0) {
    $errors[] = "Responsable (commercial) obligatoire.";
  }

  if ($data['email'] !== '' && !filter_var($data['email'], FILTER_VALIDATE_EMAIL)) {
    $errors[] = "Email invalide.";
  }

  /* Anti-doublons */
  if (!$errors && $data['phone'] !== '') {
    $st = $pdo->prepare("SELECT id FROM clients WHERE phone = ? LIMIT 1");
    $st->execute([$data['phone']]);
    if ($st->fetch()) {
      $errors[] = "Téléphone déjà existant.";
    }
  }

  if (!$errors && $data['email'] !== '') {
    $st = $pdo->prepare("SELECT id FROM clients WHERE email = ? LIMIT 1");
    $st->execute([$data['email']]);
    if ($st->fetch()) {
      $errors[] = "Email déjà existant.";
    }
  }

  /* INSERT */
  if (!$errors) {
    $stmt = $pdo->prepare("
      INSERT INTO clients
        (owner_user_id, fullname, phone, email, city, created_at)
      VALUES
        (?, ?, ?, ?, ?, NOW())
    ");

    $stmt->execute([
      $data['owner_user_id'],
      $data['fullname'],
      $data['phone'] !== '' ? $data['phone'] : null,
      $data['email'] !== '' ? $data['email'] : null,
      $data['city'] !== '' ? $data['city'] : null,
    ]);

    redirect('/public/clients/index.php');
  }
}

include __DIR__ . '/../../app/views/layout/header.php';
include __DIR__ . '/../../app/views/layout/sidebar.php';
?>

<section class="content pt-3">
<div class="container-fluid">

<div class="card">
  <div class="card-header">
    <h3 class="card-title">Ajouter un client</h3>
  </div>

  <div class="card-body">

    <?php if ($errors): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach ($errors as $e): ?>
            <li><?= e($e) ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <form method="post">

      <div class="form-group">
        <label>Nom complet</label>
        <input name="fullname" class="form-control" value="<?= e($data['fullname']) ?>" required>
      </div>

      <div class="form-row">
        <div class="form-group col-md-6">
          <label>Téléphone</label>
          <input name="phone" class="form-control" value="<?= e($data['phone']) ?>">
        </div>
        <div class="form-group col-md-6">
          <label>Email</label>
          <input name="email" class="form-control" value="<?= e($data['email']) ?>">
        </div>
      </div>

      <div class="form-group">
        <label>Ville</label>
        <input name="city" class="form-control" value="<?= e($data['city']) ?>">
      </div>

      <div class="form-group">
        <label>Responsable (commercial)</label>

        <?php if ($userRole === 'commercial'): ?>
          <input class="form-control" value="Vous (<?= e($_SESSION['user']['name']) ?>)" disabled>
          <input type="hidden" name="owner_user_id" value="<?= (int)$data['owner_user_id'] ?>">
        <?php else: ?>
          <select name="owner_user_id" class="form-control" required>
            <option value="0">— Sélectionner —</option>
            <?php foreach ($users as $u): ?>
              <option value="<?= (int)$u['id'] ?>" <?= (int)$data['owner_user_id'] === (int)$u['id'] ? 'selected' : '' ?>>
                <?= e($u['name']) ?> (<?= e($u['role']) ?>)
              </option>
            <?php endforeach; ?>
          </select>
        <?php endif; ?>
      </div>

      <button class="btn btn-success">
        <i class="fas fa-save"></i> Enregistrer
      </button>

      <a class="btn btn-secondary ml-2" href="<?= e(base_url('/public/clients/index.php')) ?>">
        Annuler
      </a>

    </form>

  </div>
</div>

</div>
</section>

<?php include __DIR__ . '/../../app/views/layout/footer.php'; ?>
