<?php
// $active : menu principal actif (ex: 'projects')
// $subactive : sous-menu actif (ex: 'projects_list')
$active = $active ?? '';
$subactive = $subactive ?? '';
?>
<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
  <ul class="navbar-nav">
    <li class="nav-item">
      <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
    </li>
  </ul>
  <ul class="navbar-nav ml-auto">
    <li class="nav-item">
      <a class="nav-link" href="<?= e(base_url('/public/logout.php')) ?>"><i class="fas fa-sign-out-alt"></i></a>
    </li>
  </ul>
</nav>

<!-- Sidebar -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
  <a href="<?= e(base_url('/public/dashboard.php')) ?>" class="brand-link">
    <span class="brand-text font-weight-light"><strong>BM Promotion - ERP<strong></span>
  </a>

  <div class="sidebar">

    <!-- Search (optionnel) -->
    <div class="form-inline mt-3">
      <div class="input-group" data-widget="sidebar-search">
        <input class="form-control form-control-sidebar" type="search" placeholder="Rechercher..." aria-label="Search">
        <div class="input-group-append">
          <button class="btn btn-sidebar">
            <i class="fas fa-search fa-fw"></i>
          </button>
        </div>
      </div>
    </div>

    <nav class="mt-3">
      <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

        <!-- DASHBOARD -->
       <li class="nav-item">
          <a href="<?= base_url('/public/dashboard/index.php') ?>"
             class="nav-link <?= $active === 'dashboard' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-chart-line"></i>
            <p>Tableau de bord</p>
          </a>
        </li>




        <li class="nav-header">PROMOTION IMMOBILIÈRE</li>

        <!-- GESTION DES PROJETS -->
        <li class="nav-item <?= $active === 'projects' ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= $active === 'projects' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-project-diagram"></i>
            <p>
              Gestion des projets
              <i class="right fas fa-angle-left"></i>
            </p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="<?= e(base_url('/public/projects/index.php')) ?>"
                 class="nav-link <?= $subactive === 'projects_list' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Liste des projets</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="<?= e(base_url('/public/projects/create.php')) ?>"
                 class="nav-link <?= $subactive === 'projects_create' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Ajouter un projet</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="<?= e(base_url('/public/projects/progress.php')) ?>"
                 class="nav-link <?= $subactive === 'projects_progress' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Avancement projet</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lot-types/index.php')) ?>"
                 class="nav-link <?= $subactive === 'lot_types' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Types de lots</p>
              </a>
            </li>
            <li class="nav-item">
              <a href="<?= e(base_url('/public/edd/index.php')) ?>"
                 class="nav-link <?= $subactive === 'edd' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>EDD (état descriptif)</p>
              </a>
            </li>
          </ul>
        </li>

        <!-- SITUATION DES LOTS -->
        <li class="nav-item has-treeview <?= $active === 'lots_status' ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= $active === 'lots_status' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-building"></i>
            <p>
              Situation des lots
              <i class="right fas fa-angle-left"></i>
            </p>
          </a>
        
          <ul class="nav nav-treeview">
        
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lots/index.php')) ?>"
                 class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>Tous les lots</p>
              </a>
            </li>
        
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lots/status.php?status=disponible')) ?>"
                 class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>Disponibles</p>
              </a>
            </li>
        
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lots/status.php?status=reserve')) ?>"
                 class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>Réservés</p>
              </a>
            </li>
        
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lots/status.php?status=vendu')) ?>"
                 class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>Vendus</p>
              </a>
            </li>
        
            <li class="nav-item">
              <a href="<?= e(base_url('/public/lots/status.php?status=bloque')) ?>"
                 class="nav-link">
                <i class="far fa-circle nav-icon"></i>
                <p>Bloqués</p>
              </a>
            </li>
        
          </ul>
        </li>


        <li class="nav-header">CRM</li>

        <!-- CLIENTS / PROSPECTS -->
       <?php require_once __DIR__ . '/../../core/Permissions.php'; ?>

        <?php if (Permissions::can(['admin','director','manager','commercial','finance'])): ?>
        <li class="nav-item">
          <a href="<?= e(base_url('/public/clients/index.php')) ?>"
             class="nav-link <?= ($active === 'clients') ? 'active' : '' ?>">
            <i class="nav-icon fas fa-user-friends"></i>
            <p>Clients / Prospects</p>
          </a>
        </li>
        <?php endif; ?>


        <!-- VISITES -->
        <li class="nav-item <?= $active === 'visits' ? 'menu-open' : '' ?>">
          <a href="#" class="nav-link <?= $active === 'visits' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-calendar-check"></i>
            <p>
              Gestion des visites
              <i class="right fas fa-angle-left"></i>
            </p>
          </a>
          <ul class="nav nav-treeview">
            <li class="nav-item">
              <a href="<?= e(base_url('/public/visits/index.php')) ?>"
                 class="nav-link <?= $subactive === 'visits_list' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Liste des visites</p>
              </a>
            </li>
             <!-- <li class="nav-item">
              <a href="<?= e(base_url('/public/visits/planning.php')) ?>"
                 class="nav-link <?= $subactive === 'visits_planning' ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Planning des visites</p>
              </a>
            </li> -->
          </ul>
        </li>

        <li class="nav-header">VENTES & FINANCES</li>

        <!-- RÉSERVATIONS -->
        <li class="nav-item">
          <a href="<?= e(base_url('/public/reservations/index.php')) ?>"
             class="nav-link <?= $active === 'reservations' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-bookmark"></i>
            <p>Réservations</p>
          </a>
        </li>

        <!-- SIMULATIONS -->
        <li class="nav-item">
          <a href="<?= e(base_url('/public/simulations/index.php')) ?>"
             class="nav-link <?= $active === 'simulations' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-calculator"></i>
            <p>Liste des simulations</p>
          </a>
        </li>


        <li class="nav-header">MARKETING SERVICE</li>

        <!-- CLIENTS / PROSPECTS -->


<li class="nav-item">
    <a class="nav-link" href="<?= base_url('/public/marketing/prospects/index.php') ?>">
      <i class="far fa-circle nav-icon"></i>
              Marketing prospection
    </a>
</li>
<li class="nav-item">
  <a href="<?= e(base_url('/public/fournisseurs/offres/index.php')) ?>"
     class="nav-link <?= ($active === 'fournisseurs') ? 'active' : '' ?>">
    <i class="nav-icon fas fa-truck"></i>
    <p>Fournisseurs Marketing</p>
  </a>
</li>


        <li class="nav-header">FINANCE</li>


        <!-- GESTION DES PAIEMENTS -->
            <li class="nav-item has-treeview <?= $active === 'payments' ? 'menu-open' : '' ?>">

              <a href="#" class="nav-link <?= $active == 'payments' ? 'active' : '' ?>">
                <i class="nav-icon fas fa-credit-card"></i>
                <p>
                  Gestion des paiements
                  <i class="right fas fa-angle-left"></i>
                </p>
              </a>
            
              <ul class="nav nav-treeview">
            
                <li class="nav-item">
                  <a href="<?= e(base_url('/public/payment_orders/index.php')) ?>"
                     class="nav-link <?= $subactive == 'ov' ? 'active' : '' ?>">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Ordres de versement</p>
                  </a>
                </li>
            
                <li class="nav-item">
                  <a href="<?= e(base_url('/public/payments/index.php')) ?>"
                     class="nav-link <?= $subactive == 'payments' ? 'active' : '' ?>">
                    <i class="far fa-circle nav-icon"></i>
                    <p>Paiements</p>
                  </a>
                </li>   
                
            <li class="nav-item">
              <a href="<?= e(base_url('/public/payment_orders/pending.php')) ?>"
                 class="nav-link <?= ($subactive == 'pending') ? 'active' : '' ?>">
                <i class="far fa-circle nav-icon"></i>
                <p>Reste à encaisser</p>
              </a>
            </li>

            
              </ul>
            </li>

<li class="nav-item has-treeview <?= $active === 'purchases' ? 'menu-open' : '' ?>">
  <a href="#" class="nav-link <?= $active === 'purchases' ? 'active' : '' ?>">
    <i class="nav-icon fas fa-truck-loading"></i>
    <p>
      Achats & Fournisseurs
      <i class="right fas fa-angle-left"></i>
    </p>
  </a>

  <ul class="nav nav-treeview">
    <li class="nav-item">
      <a href="<?= e(base_url('/public/suppliers/index.php')) ?>"
         class="nav-link <?= $subactive === 'suppliers' ? 'active' : '' ?>">
        <i class="far fa-circle nav-icon"></i>
        <p>Fournisseurs</p>
      </a>
    </li>

    <li class="nav-item">
      <a href="<?= e(base_url('/public/purchases/index.php')) ?>"
         class="nav-link <?= $subactive === 'purchases_list' ? 'active' : '' ?>">
        <i class="far fa-circle nav-icon"></i>
        <p>Achats</p>
      </a>
    </li>

    <li class="nav-item">
      <a href="<?= e(base_url('/public/purchases/create.php')) ?>"
         class="nav-link <?= $subactive === 'purchases_create' ? 'active' : '' ?>">
        <i class="far fa-circle nav-icon"></i>
        <p>Nouvel achat</p>
      </a>
    </li>
  </ul>
</li>

        <!-- TARIFICATION -->
         <!-- <li class="nav-item">
          <a href="<?= e(base_url('/public/tarification/index.php')) ?>"
             class="nav-link <?= $active === 'tarification' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-tags"></i>
            <p>Tarification des lots</p>
          </a>
        </li> -->


        <li class="nav-header">AUTRES</li>

        <!-- HISTORIQUE -->
        <li class="nav-item">
          <a href="<?= e(base_url('/public/audit/index.php')) ?>"
             class="nav-link <?= $active === 'audit' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-history"></i>
            <p>Historique des actions</p>
          </a>
        </li>




        <li class="nav-header">SYSTÈME</li>

        <!-- PARAMÈTRES -->
        <li class="nav-item">
          <a href="<?= e(base_url('/public/settings/index.php')) ?>"
             class="nav-link <?= $active === 'settings' ? 'active' : '' ?>">
            <i class="nav-icon fas fa-cogs"></i>
            <p>Paramètres</p>
          </a>
        </li>

      </ul>
    </nav>
  </div>
</aside>

<!-- Content Wrapper -->
<div class="content-wrapper">
