<?php

function base_url(string $path = ''): string
{
    return '/erp-v06' . $path;
}

function e($value)
{
    return htmlspecialchars((string)$value, ENT_QUOTES, 'UTF-8');
}

function redirect(string $path)
{
    header('Location: ' . base_url($path));
    exit;
}

function formatLot(array $lot, bool $withPrice = false): string
{
    $label = 'Lot N°' . $lot['reference'];

    if (!empty($lot['lot_type'])) {
        $label .= ' – ' . $lot['lot_type'];
    }

    if (!empty($lot['side'])) {
        $label .= ' – ' . ($lot['side'] === 'droite' ? 'À droite' : 'À gauche');
    }

    if ($withPrice && isset($lot['price'])) {
        $label .= ' – ' . number_format($lot['price'], 0, ' ', ' ') . ' DA';
    }

    return $label;
}


function badge_status($status)
{
    $map = [
        'brouillon' => ['label' => 'Brouillon', 'class' => 'secondary'],
        'soumise'   => ['label' => 'Soumise',   'class' => 'warning'],
        'acceptee'  => ['label' => 'Acceptée',  'class' => 'success'],
        'refusee'   => ['label' => 'Refusée',   'class' => 'danger'],
        'en_cours'  => ['label' => 'En cours',  'class' => 'warning'],
        'terminee'  => ['label' => 'Terminée',  'class' => 'primary'],
        'cloturee'  => ['label' => 'Clôturée',  'class' => 'dark'],
    ];

    if (!isset($map[$status])) {
        return '<span class="badge badge-secondary">'.htmlspecialchars((string)$status).'</span>';
    }

    return '<span class="badge badge-'.$map[$status]['class'].'">'.$map[$status]['label'].'</span>';
}