<?php
require_once __DIR__ . '/../config/database.php';

// Sélection des réservations expirées
$sql = "
SELECT r.id, r.lot_id
FROM reservations r
WHERE r.status = 'active'
AND r.expires_at < NOW()
";

$reservations = $pdo->query($sql)->fetchAll();

foreach ($reservations as $r) {

    // Marquer la réservation comme expirée
    $stmt = $pdo->prepare("
        UPDATE reservations
        SET status = 'expiree'
        WHERE id = ?
    ");
    $stmt->execute([$r['id']]);

    // Libérer le lot
    $stmt = $pdo->prepare("
        UPDATE lots
        SET status = 'disponible'
        WHERE id = ?
    ");
    $stmt->execute([$r['lot_id']]);
}

echo count($reservations) . " réservation(s) expirée(s).\n";
