<?php
class Stock
{
  public static function postPurchase(PDO $pdo, int $purchase_id): void
  {
    // Verrou achat
    $stmt = $pdo->prepare("SELECT * FROM purchases WHERE id=? LIMIT 1");
    $stmt->execute([$purchase_id]);
    $purchase = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$purchase) return;
    if ((int)$purchase['stock_posted'] === 1) return;
    if ($purchase['status'] !== 'VALIDATED') return;

    // Lignes
    $stmt = $pdo->prepare("SELECT * FROM purchase_lines WHERE purchase_id=?");
    $stmt->execute([$purchase_id]);
    $lines = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if (!$lines) return;

    $date = $purchase['invoice_date'] ?: date('Y-m-d');

    $ins = $pdo->prepare("
      INSERT INTO stock_moves
      (move_date, type, source_type, source_id, supplier_id, item_label, qty, unit_price, total, note)
      VALUES
      (:d,'IN','PURCHASE',:sid,:sup,:label,:q,:u,:t,:n)
    ");

    foreach ($lines as $l) {
      if ((float)$l['qty'] <= 0) continue;

      $ins->execute([
        ':d' => $date,
        ':sid' => $purchase_id,
        ':sup' => $purchase['supplier_id'],
        ':label' => $l['description'],
        ':q' => $l['qty'],
        ':u' => $l['unit_price'],
        ':t' => $l['total'],
        ':n' => $purchase['invoice_no'] ? 'Facture '.$purchase['invoice_no'] : null,
      ]);
    }

    $pdo->prepare("
      UPDATE purchases
      SET stock_posted=1, stock_posted_at=NOW()
      WHERE id=?
    ")->execute([$purchase_id]);
  }
}
