<?php

class Permissions
{
    public static function role(): string
    {
        return $_SESSION['user']['role'] ?? 'commercial';
    }

    public static function can(array $roles): bool
    {
        return in_array(self::role(), $roles);
    }

    public static function allow(array $roles): void
    {
        if (!self::can($roles)) {
            http_response_code(403);
            die('Accès refusé');
        }
    }

    public static function canFinance(): bool
    {
        return self::can(['admin','director','finance','commercial']);
    }

    public static function canDelete(): bool
    {
        return self::can(['admin','director','manager']);
    }

    public static function canManageUsers(): bool
    {
        return self::can(['admin']);
    }

    public static function canSupervise(): bool
    {
        return self::can(['admin','director']);
    }
}
