<?php

class ClientStatus
{
    /**
     * Détermine automatiquement le statut du client
     *
     * client :
     *  - au moins 1 paiement valide
     *  - OU une réservation confirmée / vendue / livrée
     *
     * prospect :
     *  - sinon
     */
    public static function get(PDO $pdo, int $client_id): string
    {
        /* =====================
           1. Vérifier paiements VALIDES
           ===================== */
        try {
            $stmt = $pdo->prepare("
                SELECT COUNT(*) 
                FROM payments
                WHERE client_id = ?
                AND status = 'valide'
            ");
            $stmt->execute([$client_id]);

            if ((int)$stmt->fetchColumn() > 0) {
                return 'client';
            }
        } catch (Throwable $e) {
            // table absente ou autre → on ignore
        }

        /* =====================
           2. Vérifier réservations CONFIRMÉES
           ===================== */
        try {
            $stmt = $pdo->prepare("
                SELECT COUNT(*) 
                FROM reservations
                WHERE client_id = ?
                AND status IN ('confirmee', 'vendue', 'livree')
            ");
            $stmt->execute([$client_id]);

            if ((int)$stmt->fetchColumn() > 0) {
                return 'client';
            }
        } catch (Throwable $e) {
            // table absente ou autre → on ignore
        }

        /* =====================
           3. Sinon prospect
           ===================== */
        return 'prospect';
    }
}
