<?php

class BusinessRules
{
    /**
     * Calcule la remise progressive selon le % payé
     * 60% => 0%
     * 100% => 6%
     */
    public static function calculateDiscount($paidPercent)
    {
        if ($paidPercent <= 60) {
            return 0;
        }

        if ($paidPercent >= 100) {
            return 6;
        }

        return round((($paidPercent - 60) / 40) * 6, 2);
    }
}
