<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/helpers.php';

class Auth {
    public static function start() {
        if (session_status() === PHP_SESSION_NONE) { session_start(); }
    }
    public static function check() : bool {
        self::start(); return isset($_SESSION['user']);
    }
    public static function user() {
        self::start(); return $_SESSION['user'] ?? null;
    }
    public static function requireLogin() {
        if (!self::check()) { redirect('/public/login.php'); }
    }
    public static function login($email, $password) : bool {
        global $pdo; self::start();
        $stmt = $pdo->prepare("SELECT id, name, email, password, role FROM users WHERE email = ? LIMIT 1");
        $stmt->execute([$email]);
        $u = $stmt->fetch();
        if (!$u) return false;
        if (!password_verify($password, $u['password'])) return false;
        unset($u['password']);
        $_SESSION['user'] = $u;
        return true;
    }
    public static function logout() {
        self::start();
        $_SESSION = [];
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000,
                $params["path"], $params["domain"],
                $params["secure"], $params["httponly"]
            );
        }
        session_destroy();
    }
}
