<?php

class Audit
{
    public static function log(array $data): void
    {
        global $pdo;

        $stmt = $pdo->prepare("
          INSERT INTO audit_actions
          (client_id, commercial_id, actor_user_id,
           action_type, entity_type, entity_id, description)
          VALUES (?, ?, ?, ?, ?, ?, ?)
        ");

        $stmt->execute([
            $data['client_id'] ?? null,
            $data['commercial_id'] ?? null,
            $_SESSION['user']['id'],
            $data['action_type'],
            $data['entity_type'],
            $data['entity_id'],
            $data['description'] ?? null
        ]);
    }
}
